/** @file   menusavegame.h
 * @brief   Declaraction of MenuSaveGame - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MENUSAVEGAME_H
#define H_WWW_MENUSAVEGAME_H

#include "menupage.h"
#include "saveslot.h"
#include <vector>

namespace WeWantWar {

/** @class  MenuSaveGame
 * @brief   The SAVE GAME - menu is an instance of this class.
 * @author  Tomi Lamminsaari
 */
class MenuSaveGame : public MenuPage
{
public:

  ///
  /// Static members and methods
  /// ==========================

  static const int BACK_TO_LEVEL_MENU = 0;


  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructor
   */
  MenuSaveGame();
  
  /** Destructor.
   */
  virtual ~MenuSaveGame();



  ///
  /// Public methods
  /// ==============

  /** Updates the contents of this menu.
   * @return    MenuPage::PAGE_CHANGE if this menu should be closed.
   *            MenuPage::NO_PAGE_CHANGE otherwise.
   */
  virtual int update();
  
  /** Draws the contents of this menu to the background buffer.
   */
  virtual void redraw();



  ///
  /// Public GET-methods
  /// ==================

  /** Returns the type of this page
   * @return    MenuPage::SAVESLOT
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::SAVESLOT; }
  
  /** Returns the index of the saveslot the player selected.
   * @return    Index of the selected saveslot.
   */
  int getSlotIndex() const;


protected:

  /** Handles the cases when user pressed enter.
   * @return    MenuPage::NO_PAGE_CHANGE or MenuPage::PAGE_CHANGE
   */
  int checkEnterKey();



  ///
  /// Members
  /// =======

  /** This vector has the possible saveslots */
  std::vector<SaveSlot> m_slots;


private:

  /** Private methods **/

  MenuSaveGame(const MenuSaveGame& rO);
  MenuSaveGame& operator = (const MenuSaveGame& rO);
};


};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: menusavegame.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:04+02  lamminsa
 * Initial revision
 *
 */
 
